IF COL_LENGTH('Valores_Tarjetas_Cred', 'Id_SPS') IS NULL 
	ALTER TABLE Valores_Tarjetas_Cred ADD Id_Payway VARCHAR(10)
GO


----------------------------------------------------------------------------------------------------------------
IF OBJECT_ID(N'Val_Pasarelas_Pagos','U') IS NULL
	CREATE TABLE Val_Pasarelas_Pagos(
		Id_Pasarela_Pago							INT IDENTITY(1,1) NOT NULL,
		Proveedor									VARCHAR(20) ,			--valores fijos ->  FISERV , PAYWAY , MERCADOPAGO , MACRO
		Descripcion_Publica							VARCHAR(50),			--leyenda para el botn de pago
		Orden										TINYINT,				--orden a mostrar el boton en la web
		Cuotas_Max									SMALLINT,				-- MP_INSTALLMENTS  --Cantidad mxima de cuotas que acepta 1,6,12,18 (vacio=1 para compatibilidad)
		Nota										TEXT,
		Activo										TINYINT,

		mp_public_key								VARCHAR(150),
		mp_access_token								VARCHAR(150),
		mp_client_id								VARCHAR(150),
		mp_client_secret							VARCHAR(150),
		mp_excluded_payment_methods 				VARCHAR(150),			--array
		mp_excluded_payment_types 					VARCHAR(150),			--array(array("id" => "ticket"));
				
		payway_url 									VARCHAR(150),
		payway_key 									VARCHAR(150),
		payway_client_url 							VARCHAR(150),
		payway_client_key 							VARCHAR(150),
				
		macro_url									VARCHAR(150),
		macro_comercio								VARCHAR(150),
		macro_comercio_sucursal						VARCHAR(150),
		macro_secretkey								VARCHAR(150),
		macro_callback_success						VARCHAR(150),
		macro_callback_cancel						VARCHAR(150),
				
		fiserv_url                          		VARCHAR(150),
		fiserv_storeid                      		VARCHAR(150),
		fiserv_sharedsecret                 		VARCHAR(150),
		fiserv_responsesuccessurl           		VARCHAR(150),
		fiserv_responsefailurl              		VARCHAR(150),
		fiserv_transactionnotificationurl 			VARCHAR(150),
		fiserv_currency 							VARCHAR(10),
		fiserv_timezone 	                		VARCHAR(150),
		fiserv_txntype 	                    		VARCHAR(150),
		fiserv_hash_algorith                		VARCHAR(150),
		fiserv_mode		                    		VARCHAR(150),
		fiserv_checkoutoptio                		VARCHAR(150),
		fiserv_api_url								VARCHAR(150),
		fiserv_api_user	                    		VARCHAR(150),
		fiserv_api_password                 		VARCHAR(150),
		fiserv_cert_pem	                    		VARCHAR(150),
		fiserv_cert_key	                    		VARCHAR(150),
		fiserv_cert_password                		VARCHAR(150),
		fiserv_authenticatetransaction              VARCHAR(150),
		fiserv_threedsrequestorchallengeindicator   VARCHAR(150),
		fiserv_threedsemvcomessagecategory          VARCHAR(150),
		                                           
		
		
		
		
		
		
		CONSTRAINT PK_VPP_PorID PRIMARY KEY CLUSTERED (	Id_Pasarela_Pago )
	)
GO

IF IndexProperty(Object_Id('Val_Pasarelas_Pagos'), 'IX_VPP_PorPro', 'IndexID') IS  NULL
	CREATE INDEX IX_VPP_PorPro ON Val_Pasarelas_Pagos (Proveedor)
GO

--------------------------------------------------------------------------------------------------------
IF OBJECT_ID(N'Prod_Listas_Precios_Pasarelas','U') IS NULL
	CREATE TABLE Prod_Listas_Precios_Pasarelas(
		ID_PLP_Pasarela		INT IDENTITY(1,1) NOT NULL,
		Id_Pasarela_Pago	INT NOT NULL,
		Cuotas				SMALLINT,
		Activo				TINYINT,
	 CONSTRAINT PK_PLPP_PorID PRIMARY KEY CLUSTERED ( ID_PLP_Pasarela )
	)
GO

IF IndexProperty(Object_Id('Prod_Listas_Precios_Pasarelas'), 'IX_PLPP_PorPas', 'IndexID') IS  NULL
	CREATE INDEX IX_PLPP_PorPas ON Prod_Listas_Precios_Pasarelas (Id_Pasarela_Pago)
GO

IF OBJECT_ID('FK_PLPP_Pasarelas', 'F') IS NULL
	ALTER TABLE Prod_Listas_Precios_Pasarelas  ADD  CONSTRAINT FK_PLPP_Pasarelas FOREIGN KEY(Id_Pasarela_Pago)
	REFERENCES Val_Pasarelas_Pagos (Id_Pasarela_Pago)
GO

